/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.overworld.giantflowers.util;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.class_1945;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3614;
import net.minecraft.class_3746;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import net.minecraft.class_5821;
import potionstudios.byg.common.world.feature.config.GiantFlowerConfig;
import potionstudios.byg.common.world.feature.gen.FeatureGenUtil;

public abstract class BYGAbstractGiantFlowerFeature<T extends GiantFlowerConfig>
extends class_3031<T> {
    public BYGAbstractGiantFlowerFeature(Codec<T> configCodec) {
        super(configCodec);
    }

    public static boolean canStemPlaceHere(class_3746 worldReader, class_2338 blockPos) {
        return worldReader.method_16358(blockPos, class_4970.class_4971::method_26215) || FeatureGenUtil.isPlant(worldReader, blockPos);
    }

    public boolean isAnotherFlowerHere(class_3746 worldReader, class_2338 blockPos) {
        return worldReader.method_16358(blockPos, state -> state.method_26164(class_3481.field_15475) || state.method_26164(class_3481.field_15503));
    }

    public void placeStem(class_2680 stemBlockState, class_5281 reader, class_2338 pos) {
        if (BYGAbstractGiantFlowerFeature.canStemPlaceHere((class_3746)reader, pos)) {
            this.setFinalBlockState((class_1945)reader, pos, stemBlockState);
        }
    }

    public void placeStemBranch(class_2680 stemBlockState, class_5281 reader, class_2338 pos) {
        if (BYGAbstractGiantFlowerFeature.canStemPlaceHere((class_3746)reader, pos)) {
            this.setFinalBlockState((class_1945)reader, pos, stemBlockState);
        }
    }

    public void placePetal(class_2680 petalBlockState, class_5281 reader, class_2338 pos) {
        if (BYGAbstractGiantFlowerFeature.isAir((class_3746)reader, pos)) {
            this.setFinalBlockState((class_1945)reader, pos, petalBlockState);
        }
    }

    public void placePetal2(class_2680 petalBlockState, class_5281 reader, class_2338 pos) {
        if (BYGAbstractGiantFlowerFeature.isAir((class_3746)reader, pos)) {
            this.setFinalBlockState((class_1945)reader, pos, petalBlockState);
        }
    }

    public void placePollen(class_2680 pollenBlockState, class_5281 reader, class_2338 pos) {
        if (BYGAbstractGiantFlowerFeature.isAir((class_3746)reader, pos)) {
            this.setFinalBlockState((class_1945)reader, pos, pollenBlockState);
        }
    }

    public boolean canGiantFlowerGrowHere(class_3746 reader, class_2338 pos) {
        return reader.method_16358(pos, state -> state.method_26164(class_3481.field_15475) || state.method_26164(class_3481.field_15503) || state.method_26215() || state.method_26207() == class_3614.field_15935 || state.method_26207() == class_3614.field_15956 || state.method_26207() == class_3614.field_15947 || state.method_26207() == class_3614.field_15923 || state.method_26207() == class_3614.field_15941);
    }

    public static boolean isAir(class_3746 reader, class_2338 pos) {
        return reader.method_16358(pos, class_4970.class_4971::method_26215);
    }

    public static boolean isDesiredGroundwDirtTag(class_3746 reader, class_2338 pos, class_2248 ... desiredGroundBlock) {
        return reader.method_16358(pos, state -> {
            class_2248 block = state.method_26204();
            int n = 0;
            class_2248[] class_2248Array = desiredGroundBlock;
            int n2 = class_2248Array.length;
            if (n < n2) {
                class_2248 block1 = class_2248Array[n];
                return state.method_26164(class_3481.field_29822) || block == block1;
            }
            return state.method_26164(class_3481.field_29822);
        });
    }

    public boolean doesFlowerHaveSpaceToGrow(class_3746 reader, class_2338 pos, int treeHeight, int canopyStartHeight, int xDistance, int zDistance, boolean isSapling, class_2338 ... trunkPositions) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        if (isSapling) {
            for (int yOffSet = 0; yOffSet <= treeHeight; ++yOffSet) {
                if (!this.canGiantFlowerGrowHere(reader, (class_2338)mutable.method_10103(x, y + yOffSet, z))) {
                    return false;
                }
                if (trunkPositions.length <= 0) continue;
                for (class_2338 trunkPos : trunkPositions) {
                    if (this.canGiantFlowerGrowHere(reader, (class_2338)mutable.method_10103(trunkPos.method_10263(), trunkPos.method_10264() + yOffSet, trunkPos.method_10260()))) continue;
                    return false;
                }
            }
            for (int yOffset = canopyStartHeight; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -xDistance; xOffset <= xDistance; ++xOffset) {
                    for (int zOffset = -zDistance; zOffset <= zDistance; ++zOffset) {
                        if (this.canGiantFlowerGrowHere(reader, (class_2338)mutable.method_10103(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isAnotherFlowerNearby(class_3746 reader, class_2338 pos, int treeHeight, int distance, boolean isSapling) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        if (!isSapling) {
            for (int yOffset = 0; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                    for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                        if (!this.isAnotherFlowerHere(reader, (class_2338)mutable.method_10103(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public final void setFinalBlockState(class_1945 worldIn, class_2338 pos, class_2680 blockState) {
        this.setBlockStateWithoutUpdates(worldIn, pos, blockState);
    }

    public void setBlockStateWithoutUpdates(class_1945 worldWriter, class_2338 blockPos, class_2680 blockState) {
        worldWriter.method_8652(blockPos, blockState, 2);
    }

    protected void method_13153(class_1945 worldIn, class_2338 pos, class_2680 state) {
        this.setBlockStateWithoutUpdates(worldIn, pos, state);
    }

    public boolean method_13151(class_5821<T> featurePlaceContext) {
        return this.place(featurePlaceContext.method_33652(), featurePlaceContext.method_33653(), featurePlaceContext.method_33654(), featurePlaceContext.method_33655(), (GiantFlowerConfig)featurePlaceContext.method_33656());
    }

    public boolean place(class_5281 worldIn, class_2794 generator, Random rand, class_2338 pos, T config) {
        return this.placeFlower(worldIn, rand, pos, ((GiantFlowerConfig)config).isPlacementForced(), config);
    }

    protected abstract boolean placeFlower(class_5281 var1, Random var2, class_2338 var3, boolean var4, T var5);
}

